import Head from "next/head";
import Link from "next/link";

export default function Home() {
    return (
        <>
            <Head>
                <title>ChatKit Multi-tenant App</title>
                <meta name="description" content="Multi-tenant ChatKit Application" />
                <meta name="viewport" content="width=device-width, initial-scale=1" />
                <link rel="icon" href="/favicon.ico" />
            </Head>
            <main className="flex min-h-screen flex-col items-center justify-center p-24">
                <h1 className="text-4xl font-bold mb-8">ChatKit Multi-tenant App</h1>
                <Link
                    href="/admin"
                    className="px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"
                >
                    Go to Admin Dashboard
                </Link>
            </main>
        </>
    );
}
